<?php

ini_set('max_execution_time', -1);
ini_set('memory_limit', '-1');
set_time_limit(-1);
require_once 'config.php'; 

function bot($method, ...$datas)
{
    $ch = curl_init("https://api.telegram.org/bot" . API_KEY . "/" . $method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        var_dump(curl_error($ch));
        return false;
    }
    return json_decode($res);
}

$backupFile = "/var/www/html/payam/Ali_backup.sql";

// حذف فایل اگر وجود دارد
if (file_exists($backupFile)) {
    unlink($backupFile);
}

// جلب خزن
exec("mysqldump -u {$user} -p'{$pass}' {$db} > $backupFile 2>&1", $output, $return_var);

if ($return_var === 0) {
    if (file_exists($backupFile)) {
        echo "Backup file exists.\n";

        $dateTime = date('Y-m-d H:i:s');

        $x = bot(
            method   : 'sendDocument',
            chat_id  : '@kahwi28h', // معرف کانال
            document : new CURLFile($backupFile),
            caption   : "Backup created on: $dateTime" 
        );

        if ($x && $x->ok) {
            echo "Backup sent to Telegram successfully.";
        } else {
            echo "Failed to send backup: " . ($x ? $x->description : 'Unknown error occurred');
        }
    } else {
        echo "Backup file does not exist.";
    }
} else {
    echo "Backup failed. Command output: " . implode("\n", $output);
}
